//Complex terrain depth pixel shader - outputs colour based on calculated depth value

struct InputType
{
	float4 position : SV_POSITION;
	float2 tex : TEXCOORD0;
	float4 depthPosition : TEXCOORD1;
};

float4 main(InputType input) : SV_TARGET
{
	//Convert depth into homogenous coordinates, return a colour of the depth value
	float depthValue;
	depthValue = input.depthPosition.z / input.depthPosition.w;
	return float4(depthValue, depthValue, depthValue, 1.0f);
}