//Gaussian Blur pixel shader - performs a gaussian blur onto a texture by combining horizontal and vertical blurs
//The kernel size has been set to 11 with a sigma of 2 - see http://dev.theomader.com/gaussian-kernel-calculator/

Texture2D texture0 : register(t0);
SamplerState sampler0 : register(s0);

cbuffer ScreenBuffer : register(b0)
{
	float2 screenDimensions;
	float2 padding;
}

struct InputType
{
	float4 position : SV_POSITION;
	float2 tex : TEXCOORD0;
	float3 normal : NORMAL;
};

float4 Gaussian(float texelSize, float2 axis, InputType input)
{
	//Kernel Size 11, Sigma 2
	int kernelSize = 11;

	float weights[] =
	{
		0.0093f,
		0.028002f,
		0.065984f,
		0.121703f,
		0.175713f,
		0.198596f,
		0.175713f,
		0.121703f,
		0.065984f,
		0.028002f,
		0.0093f
	};

	float4 colour = float4(0.0f, 0.0f, 0.0f, 0.0f);	//Initialize the colour to be totally black with no alpha

	for (int i = -(kernelSize - 1); i < (kernelSize - 1); i++)	//Loop through from left to right
	{
		//Apply the gaussian blur in the direction set, based on the weighting for this pixel
		colour += texture0.Sample(sampler0, input.tex + float2(texelSize * float(i) * axis.x, texelSize * float(i) * axis.y)) * weights[abs(i)];
	}

	return colour;
}

float4 main(InputType input) : SV_TARGET
{
	float4 horizontalGaussian = Gaussian(1.0f / screenDimensions.x, float2(1.0f, 0.0f), input);	//Calculate the texel size and perform a horizontal gaussian blur
	float4 verticalGaussian = Gaussian(1.0f / screenDimensions.y, float2(0.0f, 1.0f), input);	//Calculate the texel size and perform a vertical gaussian blur
	
	float4 retColour = (horizontalGaussian + verticalGaussian) / 2.0f;	//Average out the returned blurs
	retColour.a = 1.0f;	//The colour should be fully opaque
	return retColour;
}