//Blend pixel shader - performs a weighted blend between two textures

Texture2D firstTexture : register(t0);
Texture2D secondTexture : register(t1);
SamplerState sampler0 : register(s0);

struct InputType
{
	float4 position : SV_POSITION;
	float2 tex : TEXCOORD0;
	float3 normal : NORMAL;
};

float4 main(InputType input) : SV_TARGET
{
	float blendFactor = 0.8f;
	float4 firstColour = firstTexture.Sample(sampler0, input.tex);
	float4 secondColour = secondTexture.Sample(sampler0, input.tex);
	return (firstColour * blendFactor) + (secondColour * (1.0f - blendFactor));
}
